<?php
//cualquier classe que tenga definido un método como abstracto, debe definirse como classe abstracta.
abstract class Operacion {
  protected $valor1;
  protected $valor2;
  protected $resultado;
  public function cargar1($valor1)
  {
    $this->valor1=$valor1;
  }
  public function cargar2($valor2)
  {
    $this->valor2=$valor2;
  }
  public function imprimirResultado()
  {
    echo $this->resultado.'<br>';
  }
  //Los métodos declarados como abstractos, símplemente deben definir el método pero no la implementación.
  // Esto obliga a que todas las subclases implementen el método.
  public abstract function operar(){}
}
//Cuando se hereda de la clase madre, todos los métodos abstractos declarados en ella deben ser definidos en la 
// clase hija con la misma visibilidad:
//   - Si método abstracto es protected, la implementación debe ser protected o públic (nunca private)
//   - Si és pública, se mantendrá pública.
//   - Nunca se puede declarar con el modificador private (ya que no lo podría implementar ninguna subclase).
class Suma extends Operacion{
  public function operar()
  {
    $this->resultado=$this->valor1+$this->valor2;
  }
}

class Resta extends Operacion{
  public function operar()
  {
    $this->resultado=$this->valor1-$this->valor2;
  }
}

$suma=new Suma();
$suma->cargar1(10);
$suma->cargar2(10);
$suma->operar();
echo 'El resultado de la suma de 10+10 es:';
$suma->imprimirResultado();
$resta=new Resta();
$resta->cargar1(10);
$resta->cargar2(5);
$resta->operar();
echo 'El resultado de la diferencia de 10-5 es:';
$resta->imprimirResultado();

?>